<?php
/**
 * Astra functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Astra
 * @since 1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}



// Ocultar admin bar para todos os usuários
add_filter('show_admin_bar', '__return_false');






/**
 * Define Constants
 */
define( 'ASTRA_THEME_VERSION', '4.11.10' );
define( 'ASTRA_THEME_SETTINGS', 'astra-settings' );
define( 'ASTRA_THEME_DIR', trailingslashit( get_template_directory() ) );
define( 'ASTRA_THEME_URI', trailingslashit( esc_url( get_template_directory_uri() ) ) );
define( 'ASTRA_THEME_ORG_VERSION', file_exists( ASTRA_THEME_DIR . 'inc/w-org-version.php' ) );

/**
 * Minimum Version requirement of the Astra Pro addon.
 * This constant will be used to display the notice asking user to update the Astra addon to the version defined below.
 */
define( 'ASTRA_EXT_MIN_VER', '4.11.6' );

/**
 * Load in-house compatibility.
 */
if ( ASTRA_THEME_ORG_VERSION ) {
	require_once ASTRA_THEME_DIR . 'inc/w-org-version.php';
}

/**
 * Setup helper functions of Astra.
 */
require_once ASTRA_THEME_DIR . 'inc/core/class-astra-theme-options.php';
require_once ASTRA_THEME_DIR . 'inc/core/class-theme-strings.php';
require_once ASTRA_THEME_DIR . 'inc/core/common-functions.php';
require_once ASTRA_THEME_DIR . 'inc/core/class-astra-icons.php';

define( 'ASTRA_WEBSITE_BASE_URL', 'https://wpastra.com' );

/**
 * ToDo: Deprecate constants in future versions as they are no longer used in the codebase.
 */
define( 'ASTRA_PRO_UPGRADE_URL', ASTRA_THEME_ORG_VERSION ? astra_get_pro_url( '/pricing/', 'free-theme', 'dashboard', 'upgrade' ) : 'https://woocommerce.com/products/astra-pro/' );
define( 'ASTRA_PRO_CUSTOMIZER_UPGRADE_URL', ASTRA_THEME_ORG_VERSION ? astra_get_pro_url( '/pricing/', 'free-theme', 'customizer', 'upgrade' ) : 'https://woocommerce.com/products/astra-pro/' );

/**
 * Update theme
 */
require_once ASTRA_THEME_DIR . 'inc/theme-update/astra-update-functions.php';
require_once ASTRA_THEME_DIR . 'inc/theme-update/class-astra-theme-background-updater.php';

/**
 * Fonts Files
 */
require_once ASTRA_THEME_DIR . 'inc/customizer/class-astra-font-families.php';
if ( is_admin() ) {
	require_once ASTRA_THEME_DIR . 'inc/customizer/class-astra-fonts-data.php';
}

require_once ASTRA_THEME_DIR . 'inc/lib/webfont/class-astra-webfont-loader.php';
require_once ASTRA_THEME_DIR . 'inc/lib/docs/class-astra-docs-loader.php';
require_once ASTRA_THEME_DIR . 'inc/customizer/class-astra-fonts.php';

require_once ASTRA_THEME_DIR . 'inc/dynamic-css/custom-menu-old-header.php';
require_once ASTRA_THEME_DIR . 'inc/dynamic-css/container-layouts.php';
require_once ASTRA_THEME_DIR . 'inc/dynamic-css/astra-icons.php';
require_once ASTRA_THEME_DIR . 'inc/core/class-astra-walker-page.php';
require_once ASTRA_THEME_DIR . 'inc/core/class-astra-enqueue-scripts.php';
require_once ASTRA_THEME_DIR . 'inc/core/class-gutenberg-editor-css.php';
require_once ASTRA_THEME_DIR . 'inc/core/class-astra-wp-editor-css.php';
require_once ASTRA_THEME_DIR . 'inc/dynamic-css/block-editor-compatibility.php';
require_once ASTRA_THEME_DIR . 'inc/dynamic-css/inline-on-mobile.php';
require_once ASTRA_THEME_DIR . 'inc/dynamic-css/content-background.php';
require_once ASTRA_THEME_DIR . 'inc/dynamic-css/dark-mode.php';
require_once ASTRA_THEME_DIR . 'inc/class-astra-dynamic-css.php';
require_once ASTRA_THEME_DIR . 'inc/class-astra-global-palette.php';

// Enable NPS Survey only if the starter templates version is < 4.3.7 or > 4.4.4 to prevent fatal error.
if ( ! defined( 'ASTRA_SITES_VER' ) || version_compare( ASTRA_SITES_VER, '4.3.7', '<' ) || version_compare( ASTRA_SITES_VER, '4.4.4', '>' ) ) {
	// NPS Survey Integration
	require_once ASTRA_THEME_DIR . 'inc/lib/class-astra-nps-notice.php';
	require_once ASTRA_THEME_DIR . 'inc/lib/class-astra-nps-survey.php';
}

/**
 * Custom template tags for this theme.
 */
require_once ASTRA_THEME_DIR . 'inc/core/class-astra-attr.php';
require_once ASTRA_THEME_DIR . 'inc/template-tags.php';

require_once ASTRA_THEME_DIR . 'inc/widgets.php';
require_once ASTRA_THEME_DIR . 'inc/core/theme-hooks.php';
require_once ASTRA_THEME_DIR . 'inc/admin-functions.php';
require_once ASTRA_THEME_DIR . 'inc/core/sidebar-manager.php';

/**
 * Markup Functions
 */
require_once ASTRA_THEME_DIR . 'inc/markup-extras.php';
require_once ASTRA_THEME_DIR . 'inc/extras.php';
require_once ASTRA_THEME_DIR . 'inc/blog/blog-config.php';
require_once ASTRA_THEME_DIR . 'inc/blog/blog.php';
require_once ASTRA_THEME_DIR . 'inc/blog/single-blog.php';

/**
 * Markup Files
 */
require_once ASTRA_THEME_DIR . 'inc/template-parts.php';
require_once ASTRA_THEME_DIR . 'inc/class-astra-loop.php';
require_once ASTRA_THEME_DIR . 'inc/class-astra-mobile-header.php';

/**
 * Functions and definitions.
 */
require_once ASTRA_THEME_DIR . 'inc/class-astra-after-setup-theme.php';

// Required files.
require_once ASTRA_THEME_DIR . 'inc/core/class-astra-admin-helper.php';

require_once ASTRA_THEME_DIR . 'inc/schema/class-astra-schema.php';

/* Setup API */
require_once ASTRA_THEME_DIR . 'admin/includes/class-astra-api-init.php';

if ( is_admin() ) {
	/**
	 * Admin Menu Settings
	 */
	require_once ASTRA_THEME_DIR . 'inc/core/class-astra-admin-settings.php';
	require_once ASTRA_THEME_DIR . 'admin/class-astra-admin-loader.php';
	require_once ASTRA_THEME_DIR . 'inc/lib/astra-notices/class-astra-notices.php';
}

/**
 * Metabox additions.
 */
require_once ASTRA_THEME_DIR . 'inc/metabox/class-astra-meta-boxes.php';
require_once ASTRA_THEME_DIR . 'inc/metabox/class-astra-meta-box-operations.php';
require_once ASTRA_THEME_DIR . 'inc/metabox/class-astra-elementor-editor-settings.php';

/**
 * Customizer additions.
 */
require_once ASTRA_THEME_DIR . 'inc/customizer/class-astra-customizer.php';

/**
 * Astra Modules.
 */
require_once ASTRA_THEME_DIR . 'inc/modules/posts-structures/class-astra-post-structures.php';
require_once ASTRA_THEME_DIR . 'inc/modules/related-posts/class-astra-related-posts.php';

/**
 * Compatibility
 */
require_once ASTRA_THEME_DIR . 'inc/compatibility/class-astra-gutenberg.php';
require_once ASTRA_THEME_DIR . 'inc/compatibility/class-astra-jetpack.php';
require_once ASTRA_THEME_DIR . 'inc/compatibility/woocommerce/class-astra-woocommerce.php';
require_once ASTRA_THEME_DIR . 'inc/compatibility/edd/class-astra-edd.php';
require_once ASTRA_THEME_DIR . 'inc/compatibility/lifterlms/class-astra-lifterlms.php';
require_once ASTRA_THEME_DIR . 'inc/compatibility/learndash/class-astra-learndash.php';
require_once ASTRA_THEME_DIR . 'inc/compatibility/class-astra-beaver-builder.php';
require_once ASTRA_THEME_DIR . 'inc/compatibility/class-astra-bb-ultimate-addon.php';
require_once ASTRA_THEME_DIR . 'inc/compatibility/class-astra-contact-form-7.php';
require_once ASTRA_THEME_DIR . 'inc/compatibility/class-astra-visual-composer.php';
require_once ASTRA_THEME_DIR . 'inc/compatibility/class-astra-site-origin.php';
require_once ASTRA_THEME_DIR . 'inc/compatibility/class-astra-gravity-forms.php';
require_once ASTRA_THEME_DIR . 'inc/compatibility/class-astra-bne-flyout.php';
require_once ASTRA_THEME_DIR . 'inc/compatibility/class-astra-ubermeu.php';
require_once ASTRA_THEME_DIR . 'inc/compatibility/class-astra-divi-builder.php';
require_once ASTRA_THEME_DIR . 'inc/compatibility/class-astra-amp.php';
require_once ASTRA_THEME_DIR . 'inc/compatibility/class-astra-yoast-seo.php';
require_once ASTRA_THEME_DIR . 'inc/compatibility/surecart/class-astra-surecart.php';
require_once ASTRA_THEME_DIR . 'inc/compatibility/class-astra-starter-content.php';
require_once ASTRA_THEME_DIR . 'inc/addons/transparent-header/class-astra-ext-transparent-header.php';
require_once ASTRA_THEME_DIR . 'inc/addons/breadcrumbs/class-astra-breadcrumbs.php';
require_once ASTRA_THEME_DIR . 'inc/addons/scroll-to-top/class-astra-scroll-to-top.php';
require_once ASTRA_THEME_DIR . 'inc/addons/heading-colors/class-astra-heading-colors.php';
require_once ASTRA_THEME_DIR . 'inc/builder/class-astra-builder-loader.php';

// Elementor Compatibility requires PHP 5.4 for namespaces.
if ( version_compare( PHP_VERSION, '5.4', '>=' ) ) {
	require_once ASTRA_THEME_DIR . 'inc/compatibility/class-astra-elementor.php';
	require_once ASTRA_THEME_DIR . 'inc/compatibility/class-astra-elementor-pro.php';
	require_once ASTRA_THEME_DIR . 'inc/compatibility/class-astra-web-stories.php';
}

// Beaver Themer compatibility requires PHP 5.3 for anonymous functions.
if ( version_compare( PHP_VERSION, '5.3', '>=' ) ) {
	require_once ASTRA_THEME_DIR . 'inc/compatibility/class-astra-beaver-themer.php';
}

require_once ASTRA_THEME_DIR . 'inc/core/markup/class-astra-markup.php';

/**
 * Load deprecated functions
 */
require_once ASTRA_THEME_DIR . 'inc/core/deprecated/deprecated-filters.php';
require_once ASTRA_THEME_DIR . 'inc/core/deprecated/deprecated-hooks.php';
require_once ASTRA_THEME_DIR . 'inc/core/deprecated/deprecated-functions.php';












///////////////////////////////////////////////////////////////////////////////////////////////







  


  





 


 



 

 





//////////////TOTAL FINANCEIRO
  

 








 



 

 







 
 

 














 














 
 









 



function adicionar_menu_frete() {
    add_menu_page(
        'Novo Frete',        // T�tulo da p�gina
        'Novo Frete',        // T�tulo do menu
        'manage_options',             // Capacidade
        'frete-personalizado',        // Slug do menu
        'redirecionar_para_frete',    // Fun��o de callback
        //'dashicons-admin-site',       // �cone do menu
                             // Posi��o no menu
    );
}

add_action('admin_menu', 'adicionar_menu_frete');

function redirecionar_para_frete() {
    $url = home_url('/wp-admin/post-new.php?post_type=frete');
    echo '<script type="text/javascript">
           window.location.href="' . $url . '";
          </script>';
    exit;
}







function meu_plugin_adicionar_menu_admin() {
    // Adiciona o menu "Filtro Frete"
    add_menu_page(
        'Filtro Frete',     // T�tulo da p�gina
        'Filtro Frete',  // T�tulo do menu
        'manage_options',       // Capacidade necess�ria para ver este menu
        'filtro-frete',   // Slug do menu
        'meu_relatorio_callback' // A fun��o que vai renderizar a p�gina do menu
    );

    // Adiciona o menu "Passagem"
    add_menu_page(
        'Filtro Passagem',     // T�tulo da p�gina
        'Filtro Passagem',     // T�tulo do menu
        'manage_options', // Capacidade necess�ria para ver este menu
        'passagem',       // Slug do menu
        'meu_passagem_callback' // A fun��o que vai renderizar a p�gina do menu
    );

// Adiciona o menu "Caixa"
    add_menu_page(
        'Caixa',     // T�tulo da p�gina
        'Caixa',     // T�tulo do menu
        'manage_options', // Capacidade necess�ria para ver este menu
        'caixa',       // Slug do menu
        'meu_caixa_callback' // A fun��o que vai renderizar a p�gina do menu
    );

// Adiciona o menu "Encomenda"
    add_menu_page(
        'Encomendas',     // T�tulo da p�gina
        'Encomendas',     // T�tulo do menu
        'manage_options', // Capacidade necess�ria para ver este menu
        'encomenda',       // Slug do menu
        'meu_encomenda_callback' // A fun��o que vai renderizar a p�gina do menu
    );


 


    // Adiciona o menu "fencomenda"
    add_menu_page(
        'fencomenda',     // T�tulo da p�gina
        'fencomenda',     // T�tulo do menu
        'manage_options', // Capacidade necess�ria para ver este menu
        'fencomenda',       // Slug do menu
        'meu_fencomenda_callback' // A fun��o que vai renderizar a p�gina do menu
    );



// Adiciona o menu "filtroencomenda"
    add_menu_page(
        'filtroencomenda',     // T�tulo da p�gina
        'filtroencomenda',     // T�tulo do menu
        'manage_options', // Capacidade necess�ria para ver este menu
        'filtroencomenda',       // Slug do menu
        'meu_filtroencomenda_callback' // A fun��o que vai renderizar a p�gina do menu
    );



// Adiciona o menu "filtroebenvindo"
    add_menu_page(
        'bemvindo',     // T�tulo da p�gina
        'bemvindo',     // T�tulo do menu
        'manage_options', // Capacidade necess�ria para ver este menu
        'painel',       // Slug do menu
        'bemvindo_callback' // A fun��o que vai renderizar a p�gina do menu
    );



// Adiciona o menu "filtroebenvindo"
    add_menu_page(
        'cadpassia',     // T�tulo da p�gina
        'cadpassia',     // T�tulo do menu
        'manage_options', // Capacidade necess�ria para ver este menu
        'cadpassia',       // Slug do menu
        'cadpassia_callback' // A fun��o que vai renderizar a p�gina do menu
    );



// Adiciona o menu "cad-frete"
    add_menu_page(
        'cadfrete',     // T�tulo da p�gina
        'cadfrete',     // T�tulo do menu
        'manage_options', // Capacidade necess�ria para ver este menu
        'cadfrete',       // Slug do menu
        'cadfrete_callback' // A fun��o que vai renderizar a p�gina do menu
    );





// Adiciona o menu "Novo Frete"
    add_menu_page(
        'Novo Frete',     // T�tulo da p�gina
        'Novo Frete',     // T�tulo do menu
        'manage_options', // Capacidade necess�ria para ver este menu
        'novofrete',       // Slug do menu
        'novofrete_callback' // A fun��o que vai renderizar a p�gina do menu
    );



// Adiciona o menu "Filtro Novo Frete"
    add_menu_page(
        'Filtro Novo Frete',     // T�tulo da p�gina
        'Filtro Fretes',     // T�tulo do menu
        'manage_options', // Capacidade necess�ria para ver este menu
        'filtronovofrete',       // Slug do menu
        'filtronovofrete_callback' // A fun��o que vai renderizar a p�gina do menu
    );





  
     



}
add_action('admin_menu', 'meu_plugin_adicionar_menu_admin');


function novofrete_callback() {
    include(plugin_dir_path(__FILE__) . 'novofrete.php');
}


function filtronovofrete_callback() {
    include(plugin_dir_path(__FILE__) . 'filtronovofrete.php');
}





function meu_relatorio_callback() {
    include(plugin_dir_path(__FILE__) . 'rel.php');
}

function meu_passagem_callback() {
    include(plugin_dir_path(__FILE__) . 'pass.php');
}



function meu_caixa_callback() {
    include(plugin_dir_path(__FILE__) . 'caixa.php');
}


function meu_encomenda_callback() {
    include(plugin_dir_path(__FILE__) . 'encomenda.php');
}



 


function meu_fencomenda_callback() {
    include(plugin_dir_path(__FILE__) . 'fencomenda.php');
}


function meu_filtroencomenda_callback() {
    include(plugin_dir_path(__FILE__) . 'filtroencomenda.php');
}




function bemvindo_callback() {
    include(plugin_dir_path(__FILE__) . 'bemvindo.php');
}




function cadpassia_callback() {
    include(plugin_dir_path(__FILE__) . 'cad-pass-ia.php');
}





function cadfrete_callback() {
    include(plugin_dir_path(__FILE__) . 'cadfrete.php');
}



/////////////////


 



 





//////////////////ENCOMENDAS


  


// Registrar o Custom Post Type 'encomendas'
function registrar_cpt_encomendas() {
    $labels = array(
        'name'               => 'Encomendas',
        'singular_name'      => 'Encomenda',
        'menu_name'          => 'Encomendas',
        'name_admin_bar'     => 'Encomenda',
        'add_new'            => 'Adicionar Nova',
        'add_new_item'       => 'Adicionar Nova Encomenda',
        'new_item'           => 'Nova Encomenda',
        'edit_item'          => 'Editar Encomenda',
        'view_item'          => 'Ver Encomenda',
        'all_items'          => 'Todas as Encomendas',
        'search_items'       => 'Procurar Encomendas',
        'not_found'          => 'Nenhuma encomenda encontrada',
        'not_found_in_trash' => 'Nenhuma encomenda encontrada na lixeira',
    );

    $args = array(
        'labels'             => $labels,
        'public'             => true,
        'publicly_queryable' => true,
        'show_ui'            => true,
        'show_in_menu'       => true,
        'query_var'          => true,
        'rewrite'            => array('slug' => 'encomendas'),
        'capability_type'    => 'post',
        'has_archive'        => true,
        'hierarchical'       => false,
        'menu_position'      => 5,
        'supports'           => array('title'),
        'show_in_rest'       => true,
    );

    register_post_type('encomendas', $args);
}
add_action('init', 'registrar_cpt_encomendas');

// Fun��o para capturar os dados do formul�rio e criar um novo post no CPT 'encomendas'
add_action('admin_post_nopriv_cadastrar_encomenda', 'cadastrar_encomenda_funcao');
add_action('admin_post_cadastrar_encomenda', 'cadastrar_encomenda_funcao');


 

  function cadastrar_encomenda_funcao() {
    // Verifica se os campos obrigatórios foram enviados
    if (!empty($_POST['nome_remetente']) && !empty($_POST['contato_remetente']) && !empty($_POST['nome_destinatario'])) {

        // Cria um novo post no CPT 'encomendas'
        $post_id = wp_insert_post(array(
            'post_title'   => sanitize_text_field($_POST['nome_remetente']),
            'post_type'    => 'encomendas',
            'post_status'  => 'publish',
        ));

        // Verifica se o post foi criado com sucesso
        if ($post_id) {
            // Salva todos os campos como metadados
            foreach ($_POST as $key => $value) {
                if ($key !== 'action') {
                    update_post_meta($post_id, sanitize_text_field($key), sanitize_text_field($value));
                }
            }

            // Recupera os valores salvos
            $tipoP   = get_post_meta($post_id, 'tipoP', true);
            $tipocat = get_post_meta($post_id, 'tipocat', true);

          // Redirecionamento condicional ajustado
if ($tipocat === 'Frete' && $tipoP === 'Receber') {
    wp_redirect(site_url('/novofrete?status=sucesso'));
} elseif ($tipocat === 'Frete') {
    wp_redirect(site_url('/fencomenda/?envio=remetok&encomendaid=' . $post_id));
} elseif ($tipocat === 'Encomenda') {
    wp_redirect(site_url('/cencomenda/?envio=remetok&encomendaid=' . $post_id));
} else {
    wp_redirect(site_url('/cencomenda/?envio=remetok&encomendaid=' . $post_id));
}
exit;

exit;


        } else {
            // Erro ao criar post
            wp_redirect(add_query_arg('status', 'error', wp_get_referer()));
            exit;
        }

    } else {
        // Campos obrigatórios não preenchidos
        wp_redirect(add_query_arg('status', 'error', home_url('/cadastro-encomenda/')));
        exit;
    }
}



// Adiciona um metabox para exibir os campos personalizados dinamicamente no CPT 'encomendas'
function adicionar_metabox_campos_personalizados() {
    add_meta_box(
        'metabox_campos_personalizados',    // ID do metabox
        'Detalhes da Encomenda',            // T�tulo do metabox
        'exibir_metabox_encomenda',         // Fun��o que exibe os campos
        'encomendas',                       // CPT onde ser� exibido
        'normal',                           // Contexto (normal, side, etc.)
        'default'                           // Prioridade
    );
}
add_action('add_meta_boxes', 'adicionar_metabox_campos_personalizados');

// Fun��o que exibe o metabox com os campos personalizados dinamicamente
function exibir_metabox_encomenda($post) {
    // Recupera todos os meta dados do post
    $meta_dados = get_post_meta($post->ID);

    echo '<table class="form-table">';
    foreach ($meta_dados as $key => $value) {
        // Ignora campos internos do WordPress (campos que come�am com "_")
        if (substr($key, 0, 1) !== '_') {
            echo '<tr>';
            echo '<th><label for="' . esc_attr($key) . '">' . esc_html(ucwords(str_replace('_', ' ', $key))) . '</label></th>';
            echo '<td><input type="text" name="' . esc_attr($key) . '" value="' . esc_attr($value[0]) . '" class="regular-text"></td>';
            echo '</tr>';
        }
    }
    echo '</table>';
}

// Fun��o para salvar os campos personalizados edit�veis
function salvar_campos_personalizados_encomenda($post_id) {
    // Verifica se � um pedido de salvamento v�lido
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;

    // Garante que os campos sejam salvos apenas no CPT 'encomendas'
    if (isset($_POST['post_type']) && $_POST['post_type'] === 'encomendas') {
        foreach ($_POST as $key => $value) {
            // Salva os campos personalizados, exceto campos internos do WordPress
            if (substr($key, 0, 1) !== '_') {
                update_post_meta($post_id, sanitize_text_field($key), sanitize_text_field($value));
            }
        }
    }
}
add_action('save_post', 'salvar_campos_personalizados_encomenda');



 




////////////////PARA FRETE ADICIONAR NNOVO FRETE

 



 














 



 
// Fun��o AJAX para buscar remetentes ou destinat�rios existentes
function buscar_remetente_destinatario() {
    global $wpdb;

    // Verifica se o campo 'tipo' foi enviado (remetente ou destinatario)
    $termo = isset($_POST['termo']) ? sanitize_text_field($_POST['termo']) : '';

    if ($termo) {
        // Configura a query para buscar encomendas com base no nome do remetente ou destinat�rio
        $query_args = array(
            'post_type' => 'encomendas',
            'posts_per_page' => -1,
            'meta_query' => array(
                'relation' => 'OR', // Busca por remetente OU destinat�rio
                array(
                    'key' => 'nome_remetente',
                    'value' => $termo,
                    'compare' => 'LIKE',
                ),
                array(
                    'key' => 'nome_destinatario',
                    'value' => $termo,
                    'compare' => 'LIKE',
                ),
            ),
        );

        $query = new WP_Query($query_args);

        $resultados = array();
        $nomes_existem = array(); // Array para checar nomes existentes e evitar duplicatas

        // Percorre os resultados e coleta os meta dados
        if ($query->have_posts()) {
            while ($query->have_posts()) {
                $query->the_post();
                $id = get_the_ID();
                
                // Busca tanto os dados de remetente quanto de destinat�rio
                $nome_remetente = get_post_meta($id, 'nome_remetente', true);
                $telefone_remetente = get_post_meta($id, 'contato_remetente', true);
                $cpf_remetente = get_post_meta($id, 'cpf_remetente', true);

                $nome_destinatario = get_post_meta($id, 'nome_destinatario', true);
                $telefone_destinatario = get_post_meta($id, 'contato_destinatario', true);
                $cpf_destinatario = get_post_meta($id, 'cpf_destinatario', true);

                // Verifica se o nome cont�m o termo digitado e adiciona ao resultado sem duplicar
                if ($nome_remetente && stripos($nome_remetente, $termo) !== false && !in_array($nome_remetente, $nomes_existem)) {
                    $resultados[] = array(
                        'nome' => $nome_remetente,
                        'telefone' => $telefone_remetente,
                        'cpf' => $cpf_remetente,
                    );
                    $nomes_existem[] = $nome_remetente; // Evita duplicatas
                }

                if ($nome_destinatario && stripos($nome_destinatario, $termo) !== false && !in_array($nome_destinatario, $nomes_existem)) {
                    $resultados[] = array(
                        'nome' => $nome_destinatario,
                        'telefone' => $telefone_destinatario,
                        'cpf' => $cpf_destinatario,
                    );
                    $nomes_existem[] = $nome_destinatario; // Evita duplicatas
                }
            }
        }

        wp_reset_postdata();

        // Retorna o resultado em formato JSON
        if (!empty($resultados)) {
            wp_send_json($resultados);
        } else {
            wp_send_json(array('message' => 'Nenhum resultado encontrado.'));
        }
    }

    wp_die(); // Finaliza a requisi��o AJAX
}

// Adicionar as a��es AJAX (para usu�rios logados e n�o logados)
add_action('wp_ajax_buscar_remetente_destinatario', 'buscar_remetente_destinatario');
add_action('wp_ajax_nopriv_buscar_remetente_destinatario', 'buscar_remetente_destinatario');







 





 



 

// Fun��o para auto formatar campos em moeda Real conforme a digita��o
function formatar_campo_moeda_real() {
    ?>
    <script type="text/javascript">
        document.addEventListener('DOMContentLoaded', function () {
            // Lista de campos ACF a serem formatados
            const campos = document.querySelectorAll([data-name="valor"],[data-name="avulso_dinheiro"], [data-name="avulso_pix"], [data-name="avulso_debito"], [data-name="avulso_credito"]'); // Adicione os nomes dos campos conforme necess�rio

            campos.forEach(function (campo) {
                campo.addEventListener('input', function (e) {
                    let valor = e.target.value;
                    valor = valor.replace(/\D/g, ''); // Remove caracteres n�o num�ricos
                    valor = (valor / 100).toFixed(2) + ''; // Converte para formato de moeda
                    valor = valor.replace('.', ',');
                    valor = valor.replace(/(\d)(?=(\d{3})+(?!\d))/g, '$1.'); // Adiciona os pontos de milhar
                    e.target.value = valor;
                });
            });
        });
    </script>
    <?php
}
add_action('admin_footer', 'formatar_campo_moeda_real');
add_action('wp_footer', 'formatar_campo_moeda_real');










function adicionar_papel_personalizado() {
    add_role(
        'grupo_encomenda', // Identificador do papel
        'Grupo Encomendas', // Nome exibido
        array(
            'read' => true,
            // Adicione outras capacidades conforme necess�rio
        )
    );
}
add_action('init', 'adicionar_papel_personalizado');















function remover_links_visuais_admin() {
    echo '<style>
        .row-actions .view,
        #edit-slug-box,
        .misc-pub-post-status {
            display: none !important;
        }
    </style>';
}
add_action('admin_head', 'remover_links_visuais_admin');




function remover_item_barra_admin($wp_admin_bar) {
    $wp_admin_bar->remove_node('view');
}
add_action('admin_bar_menu', 'remover_item_barra_admin', 999);











add_filter('wp_is_application_passwords_available', '__return_true');

//////////////////ID �NICO
// Fun��o para gerar identificadores �nicos sequenciais com trava
function generate_sequential_unique_id_with_lock($prefix, $initial_digits = 3) {
    global $wpdb;

    // Nome da op��o que controla o lock
    $lock_option = 'sequential_unique_id_lock';

    // Tenta adquirir o lock
    if (get_option($lock_option)) {
        // Aguarda o lock ser liberado em alta concorr�ncia
        sleep(1);
        return generate_sequential_unique_id_with_lock($prefix, $initial_digits);
    }

    // Configura o lock
    update_option($lock_option, true);

    try {
        $digits = $initial_digits; // Come�a com o n�mero inicial de d�gitos
        $max_attempts = 10; // Limite de tentativas para evitar loops infinitos
        $attempt = 0;

        do {
            // Determina o valor m�nimo e m�ximo com base no n�mero de d�gitos atual
            $min_value = pow(10, $digits - 1); // Exemplo: 3 d�gitos -> 100
            $max_value = pow(10, $digits) - 1; // Exemplo: 3 d�gitos -> 999

            // Obt�m o maior valor j� existente no banco para o prefixo
            $last_id = $wpdb->get_var($wpdb->prepare(
                "SELECT CAST(SUBSTRING(meta_value, %d) AS UNSIGNED) AS id_number
                 FROM {$wpdb->postmeta}
                 WHERE meta_key = 'idunico' AND meta_value LIKE %s
                 ORDER BY id_number DESC LIMIT 1",
                strlen($prefix) + 1, // Offset do prefixo
                $wpdb->esc_like($prefix) . '%'
            ));

            // Calcula o pr�ximo n�mero
            $next_number = $last_id ? $last_id + 1 : $min_value;

            // Verifica se o n�mero atual ultrapassa o limite para os d�gitos
            if ($next_number > $max_value) {
                $digits++;
                if ($digits > 12) { // Limite m�ximo de 12 d�gitos
                    throw new Exception("O limite de 12 d�gitos foi atingido. N�o � poss�vel gerar mais identificadores.");
                }
                continue; // Tenta com mais d�gitos
            }

            // Monta o ID �nico com o prefixo
            $unique_id = $prefix . str_pad($next_number, $digits, '0', STR_PAD_LEFT);

            // Verifica se j� existe no banco de dados (precau��o)
            $exists = $wpdb->get_var($wpdb->prepare(
                "SELECT meta_id FROM {$wpdb->postmeta} WHERE meta_key = 'idunico' AND meta_value = %s",
                $unique_id
            ));

            $attempt++;
        } while ($exists && $attempt < $max_attempts);

        if ($attempt >= $max_attempts) {
            throw new Exception("Falha ao gerar um ID �nico ap�s {$max_attempts} tentativas.");
        }

        return $unique_id;
    } catch (Exception $e) {
        error_log('Erro ao gerar ID �nico: ' . $e->getMessage());
        return false;
    } finally {
        // Libera o lock
        delete_option($lock_option);
    }
}

// Hook para adicionar o identificador �nico aos posts
add_action('save_post', function ($post_id, $post, $update) {
    // Evita revis�es, autosaves e posts que j� possuem ID �nico
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;
    if (wp_is_post_revision($post_id)) return;

    // Verifica se o identificador j� foi gerado para este post
    $unique_id = get_post_meta($post_id, 'idunico', true);
    if (empty($unique_id)) {
        // Define o prefixo do identificador
        $prefix = defined('BILHETE_PREFIX') ? BILHETE_PREFIX : '1-';

        // Gera o identificador �nico sequencial come�ando com 3 d�gitos
        $unique_id = generate_sequential_unique_id_with_lock($prefix, 3);

        // Salva o identificador �nico como metadado do post
        if ($unique_id !== false) {
            update_post_meta($post_id, 'idunico', $unique_id);
        } else {
            error_log("Falha ao gerar um identificador �nico para o post ID: {$post_id}.");
        }
    }
}, 10, 3);

// Certifica-se de que o c�digo funciona tanto no frontend quanto no backend
add_action('rest_after_insert_post', function ($post, $request, $creating) {
    if ($creating) {
        $unique_id = get_post_meta($post->ID, 'idunico', true);
        if (empty($unique_id)) {
            $prefix = defined('BILHETE_PREFIX') ? BILHETE_PREFIX : '1-';
            $unique_id = generate_sequential_unique_id_with_lock($prefix, 3);

            if ($unique_id !== false) {
                update_post_meta($post->ID, 'idunico', $unique_id);
            } else {
                error_log("Falha ao gerar um identificador �nico para o post ID: {$post->ID} via REST.");
            }
        }
    }
}, 10, 3);







 

 


function deletar_todos_posts_encomendas() {
    // Argumentos da query
    $args = array(
        'post_type'      => 'encomendas', // Tipo de post
        'posts_per_page' => -1,          // Retorna todos os posts
        'post_status'    => 'any',       // Inclui todos os status (publish, draft, etc.)
        'fields'         => 'ids',      // Retorna apenas os IDs dos posts
    );

    // Query para buscar os posts
    $query = new WP_Query($args);

    // Verifica se h� posts a deletar
    if ($query->have_posts()) {
        foreach ($query->posts as $post_id) {
            wp_delete_post($post_id, true); // Deleta o post permanentemente
        }
    }

    // Reseta a query global
    wp_reset_postdata();
}

 
//deletar_todos_posts_encomendas();




  










//// ADICIONAR MANUAL O PRODUTO ENCOMENDA 
 
add_action('wp_ajax_adicionar_produto_manual', 'adicionar_produto_manual');
add_action('wp_ajax_nopriv_adicionar_produto_manual', 'adicionar_produto_manual');

function adicionar_produto_manual() {
    if (!defined('DOING_AJAX') || !DOING_AJAX) {
        wp_die('Acesso n�o autorizado');
    }

    // Limpa qualquer buffer de sa�da para evitar erro no JSON
    while (ob_get_level()) {
        ob_end_clean();
    }

    if (!isset($_POST['nome']) || !isset($_POST['valor'])) {
        wp_send_json_error(['message' => 'Preencha todos os campos.']);
    }

    $nome = sanitize_text_field($_POST['nome']);
    $valor = sanitize_text_field($_POST['valor']);
    $valor_float = floatval(str_replace(',', '.', preg_replace('/[^\d,\.]/', '', $valor)));

    $produto_id = wp_insert_post([
        'post_title'   => $nome,
        'post_type'    => 'produto_encomenda',
        'post_status'  => 'publish',
    ]);

    if (is_wp_error($produto_id)) {
        wp_send_json_error(['message' => 'Erro ao criar o produto.']);
    }

    update_post_meta($produto_id, 'valor', $valor_float);

    // Envia de volta para o JS
    wp_send_json_success([
        'id'    => $produto_id,
        'nome'  => $nome,
        'valor' => $valor_float
    ]);
}





 // ADICIONAR MANUALMENTE O PRODUTO DE FRETE
add_action('wp_ajax_adicionar_produto_frete', 'adicionar_produto_frete');
add_action('wp_ajax_nopriv_adicionar_produto_frete', 'adicionar_produto_frete');

function adicionar_produto_frete() {
    if (!defined('DOING_AJAX') || !DOING_AJAX) {
        wp_die('Acesso n�o autorizado');
    }

    while (ob_get_level()) {
        ob_end_clean();
    }

    if (!isset($_POST['nome']) || !isset($_POST['valor'])) {
        wp_send_json_error(['message' => 'Preencha todos os campos.']);
    }

    $nome = sanitize_text_field($_POST['nome']);
    $valor = sanitize_text_field($_POST['valor']);
    $valor_float = floatval(str_replace(',', '.', preg_replace('/[^\d,\.]/', '', $valor)));

    $produto_id = wp_insert_post([
        'post_title'   => $nome,
        'post_type'    => 'cad_frete_produto',
        'post_status'  => 'publish',
    ]);

    if (is_wp_error($produto_id)) {
        wp_send_json_error(['message' => 'Erro ao criar o produto.']);
    }

    update_post_meta($produto_id, 'valor', $valor_float);

    wp_send_json_success([
        'id'    => $produto_id,
        'nome'  => $nome,
        'valor' => $valor_float
    ]);
}










////BUSCAR PRODUTO ENCOMENDA

add_action('wp_ajax_buscar_produtos', 'buscar_produtos');
add_action('wp_ajax_nopriv_buscar_produtos', 'buscar_produtos');

function buscar_produtos() {
    check_ajax_referer('buscar_produtos_nonce', 'nonce');

    $search_term = isset($_POST['termo']) ? sanitize_text_field($_POST['termo']) : '';

    $args = array(
        'post_type'      => 'produto_encomenda',
        'posts_per_page' => -1,
        'orderby'        => 'date',
        'order'          => 'DESC',
        's'              => $search_term,
    );

    $query = new WP_Query($args);
    $results = array();

    if ($query->have_posts()) {
        while ($query->have_posts()) {
            $query->the_post();

            $id    = get_the_ID();
            $nome  = get_the_title();
            $valor = get_post_meta($id, 'valor', true);

            // Garante valor num�rico
            $valor_float = floatval(str_replace(',', '.', preg_replace('/[^\d,\.]/', '', $valor)));

            $results[] = array(
                'id'    => $id,
                'nome'  => $nome,
                'valor' => $valor_float,
                'text'  => $nome . ' - R$ ' . number_format($valor_float, 2, ',', '.')
            );
        }
        wp_reset_postdata();

        wp_send_json_success($results);
    } else {
        wp_send_json_error(array('message' => 'Nenhum produto encontrado.'));
    }
}








 

// BUSCAR PRODUTO PARA FRETE (autocomplete)
add_action('wp_ajax_buscar_produtos_frete', 'buscar_produtos_frete');
add_action('wp_ajax_nopriv_buscar_produtos_frete', 'buscar_produtos_frete');

function buscar_produtos_frete() {
    // Verifica o nonce (deve bater com o usado no JS)
    check_ajax_referer('buscar_produtos_nonce', 'nonce');

    $search_term = isset($_POST['termo']) ? sanitize_text_field($_POST['termo']) : '';

    $args = array(
        'post_type'      => 'cad_frete_produto',
        'posts_per_page' => -1,
        'orderby'        => 'date',
        'order'          => 'DESC',
        's'              => $search_term,
    );

    $query = new WP_Query($args);
    $results = array();

    if ($query->have_posts()) {
        while ($query->have_posts()) {
            $query->the_post();

            $id    = get_the_ID();
            $nome  = get_the_title();
            $valor = get_post_meta($id, 'valor', true);

            $valor_float = floatval(str_replace(',', '.', preg_replace('/[^\d,\.]/', '', $valor)));

            $results[] = array(
                'id'    => $id,
                'nome'  => $nome,
                'valor' => $valor_float,
                'text'  => $nome . ' - R$ ' . number_format($valor_float, 2, ',', '.')
            );
        }

        wp_reset_postdata();
        wp_send_json_success($results);
    } else {
        wp_send_json_error(['message' => 'Nenhum produto encontrado.']);
    }
}




















 
/* ===========================================================
 *  AJAX callback: atualizar_pagamento_encomenda
 *  � Salva metas sem subtrair o desconto de novo
 * =========================================================== */
function atualizar_pagamento_encomenda() {

    /* --- Seguran�a --- */
    if ( ! isset( $_POST['nonce'] ) || ! wp_verify_nonce( $_POST['nonce'], 'atualizar_pagamento_encomenda' ) ) {
        wp_send_json_error( 'Nonce inv�lido.' );
    }

    $post_id = intval( $_POST['post_ids'] ?? 0 );
    if ( ! $post_id ) {
        wp_send_json_error( 'ID do post n�o foi enviado.' );
    }

    /* --- Helper de formata��o pt-BR --- */
    $fmt = fn($v) => number_format( floatval($v), 2, ',', '.' );

    /* --- Valores vindos do JavaScript --- */
    $dinheiro = floatval( $_POST['valor_dinheiro'] ?? 0 );
    $pix      = floatval( $_POST['valor_pix']      ?? 0 );
    $debito   = floatval( $_POST['valor_debito']   ?? 0 );
    $credito  = floatval( $_POST['valor_credito']  ?? 0 );
    $desconto = floatval( $_POST['valor_desconto'] ?? 0 );

    /* ? Total pago e devido J� v�m prontos do front (sem mexer!) */
    $total_pago   = floatval( $_POST['valor_total_pago']   ?? 0 ); // 15,00
    $total_devido = floatval( $_POST['valor_total_devido'] ?? 0 ); // 0,00

    /* --- Grava metas --- */
    update_post_meta( $post_id, 'valor_dinheiro',     $fmt($dinheiro) );
    update_post_meta( $post_id, 'valor_pix',          $fmt($pix) );
    update_post_meta( $post_id, 'valor_debito',       $fmt($debito) );
    update_post_meta( $post_id, 'valor_credito',      $fmt($credito) );
    update_post_meta( $post_id, 'valor_desconto',     $fmt($desconto) );

    update_post_meta( $post_id, 'valor_total_pago',   $fmt($total_pago) );
    update_post_meta( $post_id, 'valor_total_devido', $fmt(max(0, $total_devido)) );

    if ( isset($_POST['data_pagamento']) ) {
        update_post_meta( $post_id, 'data_pagamento', sanitize_text_field($_POST['data_pagamento']) );
    }

    wp_send_json_success( 'Pagamentos atualizados com sucesso.' );
}
add_action( 'wp_ajax_atualizar_pagamento_encomenda', 'atualizar_pagamento_encomenda' );





// Oculta o editor apenas para o post type wbtm_bus
add_action('admin_init', function() {
    remove_post_type_support('wbtm_bus', 'editor');
});




 
 

//////////////////////////////TAXA







/////////////my acount 
 
















 











 














 













/* 1) Esconde a Admin Bar no front-end para todos */
add_filter('show_admin_bar', '__return_false');

/* 2) Remove o “empurrão” de margem que alguns temas aplicam quando a barra existe */
add_action('get_header', function () {
    remove_action('wp_head', '_admin_bar_bump_cb');
});

/* 3) Bloqueia acesso ao /wp-admin para quem não é admin (exceto AJAX) */
add_action('admin_init', function () {
    if (!current_user_can('manage_options') && !wp_doing_ajax()) {
        wp_safe_redirect(home_url());
        exit;
    }
});



















// TESTE: adiciona "Sair" em QUALQUER menu quando logado
add_filter('wp_nav_menu_items', function($items, $args){
    if (is_user_logged_in()) {
        $logout = esc_url( wp_logout_url( home_url() ) );
        $items .= '<li class="menu-item menu-item-logout"><a href="'.$logout.'">Sair</a></li>';
    }
    return $items;
}, 10, 2);






 




 







 

 


 


// Coloque no seu functions.php do tema ativo

function substituir_nomes_script() {
    ?>
    <script>
    document.addEventListener("DOMContentLoaded", function () {
        // Lista de substituições
        const substituicoes = {
            "ônibus": "transporte",
            "carro": "veículo",
            "barco": "lancha",
            "Tipo de treinador": "Tipo",
            "/Assento": ""
        };

        function substituirTextoNoElemento(el) {
            if (el.nodeType === 3) { // nó de texto
                let texto = el.nodeValue;
                for (let palavra in substituicoes) {
                    let regex = new RegExp(palavra, "gi");
                    texto = texto.replace(regex, substituicoes[palavra]);
                }
                el.nodeValue = texto;
            } else if (el.nodeType === 1 && el.childNodes) { 
                el.childNodes.forEach(substituirTextoNoElemento);
            }
        }

        // Substitui no carregamento inicial
        substituirTextoNoElemento(document.body);

        // Observa mudanças no DOM (para quando aparece texto novo depois de clique/AJAX)
        const observer = new MutationObserver(mutations => {
            mutations.forEach(mutation => {
                mutation.addedNodes.forEach(node => {
                    substituirTextoNoElemento(node);
                });
            });
        });

        observer.observe(document.body, {
            childList: true,
            subtree: true
        });
    });
    </script>
    <?php
}
add_action('wp_footer', 'substituir_nomes_script');


 
 




add_action('wp_footer', function () {
    ?>
    <script>
    document.addEventListener("DOMContentLoaded", function() {
        // Função que força o valor para 1
        function setInputToOne(input) {
            if (input && input.value === "0") {
                input.value = "1";
                input.dispatchEvent(new Event('change'));
            }
        }

        // Observer para monitorar quando o input aparecer no DOM
        const observer = new MutationObserver(() => {
            document.querySelectorAll('input.wbtm_number_validation[name="extra_service_qty[]"]').forEach(setInputToOne);
        });

        // observa mudanças no body
        observer.observe(document.body, { childList: true, subtree: true });

        // já tenta de cara (caso já esteja no DOM)
        document.querySelectorAll('input.wbtm_number_validation[name="extra_service_qty[]"]').forEach(setInputToOne);
    });
    </script>
    <?php
});








 



















/////tarifa 



/* ===========================================================
 * TARIFA DE TRANSPORTE — Preço já inclui tarifa (desembute + fee)
 * - Ajusta o preço do item para "valor" (= preço atual - tarifa)
 * - Adiciona a tarifa como FEE por assento (1 linha por QTD)
 * - Exibe no item: valor + tarifa = total
 * - Grava no pedido (admin/e-mail/obrigado)
 * ===========================================================*/

/* === CONFIGURAÇÕES ======================================== */
// ATIVEI o modo "preço já inclui tarifa":
define('GERATEC_PRECO_INCLUI_TARIFA', true);

// Se a tarifa deve ser tributada, mude para true:
if (!defined('GERATEC_TARIFA_TRIBUTAVEL')) define('GERATEC_TARIFA_TRIBUTAVEL', false);

/* === Compatibilidade Checkout Blocks ====================== */
add_action('before_woocommerce_init', function(){
  if (class_exists('\Automattic\WooCommerce\Utilities\FeaturesUtil')) {
    \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('cart_checkout_blocks', __FILE__, true);
  }
});

/* === 1) Campo "Tarifa de Transporte" no Admin ============ */
add_action('add_meta_boxes', function () {
  foreach (array('product','wbtm_bus') as $pt) {
    add_meta_box(
      'tarifa_transporte_meta',
      'Tarifa de Transporte',
      function($post){
        $valor = get_post_meta($post->ID, '_tarifa_transporte', true);
        ?>
        <label for="tarifa_transporte">Valor (R$):</label>
        <input type="number" step="0.01" min="0" name="tarifa_transporte" id="tarifa_transporte"
               value="<?php echo esc_attr($valor); ?>" style="width:100%">
        <p style="margin-top:6px;color:#666">Cobrança <b>por assento</b>, adicionada como taxa (fee) no checkout.</p>
        <?php
      },
      $pt, 'side', 'default'
    );
  }
});
add_action('save_post', function($post_id){
  if (isset($_POST['tarifa_transporte'])) {
    $raw = (string)$_POST['tarifa_transporte'];
    $raw = str_replace('.', '', $raw);
    $raw = str_replace(',', '.', $raw);
    update_post_meta($post_id, '_tarifa_transporte', wc_format_decimal($raw));
  }
});

/* === Helpers ============================================= */
if (!function_exists('geratec_get_tarifa_transporte')) {
  function geratec_get_tarifa_transporte($product_id, $cart_item = null){
    $tarifa = get_post_meta($product_id, '_tarifa_transporte', true);

    // Fallback: alguns plugins salvam a rota no item do carrinho
    if (($tarifa === '' || $tarifa === null) && is_array($cart_item)) {
      foreach (array('wbtm_bus_id','bus_id','route_id') as $k) {
        if (!empty($cart_item[$k])) {
          $try = get_post_meta((int)$cart_item[$k], '_tarifa_transporte', true);
          if ($try !== '' && $try !== null) { $tarifa = $try; break; }
        }
      }
    }
    $tarifa = floatval(wc_format_decimal($tarifa ? $tarifa : 0));
    return max(0, $tarifa);
  }
}

/* === 2) Desembutir a TARIFA do preço do item ================================
 * Mantém o total correto: "valor" (preço-ajustado) + fee(tarifa) = preço original.
 */
add_action('woocommerce_before_calculate_totals', function($cart){
  if (is_admin() && !defined('DOING_AJAX')) return;
  if (empty($cart)) return;
  if (!defined('GERATEC_PRECO_INCLUI_TARIFA') || GERATEC_PRECO_INCLUI_TARIFA !== true) return;

  foreach ($cart->get_cart() as $key => $ci) {
    if (!empty($ci['geratec_price_adjusted'])) continue; // evita rodar 2x

    $product = $ci['data'];
    if (!$product || !is_a($product, 'WC_Product')) continue;

    $tarifa = geratec_get_tarifa_transporte($ci['product_id'], $ci);
    if ($tarifa <= 0) continue;

    // Preço exibido (pode incluir impostos conforme config WC):
    $preco_display_original = (float) wc_get_price_to_display($product);
    $valor_display          = max(0, $preco_display_original - $tarifa);

    // Converte para "preço cru" usando fator de proporção
    $base_original = (float) $product->get_price();
    if ($preco_display_original > 0 && $base_original >= 0) {
      $fator = $valor_display / $preco_display_original;
      $novo_base = max(0, $base_original * $fator);
      $product->set_price( wc_format_decimal($novo_base) );
      $ci['geratec_price_adjusted'] = 1;
      // guarda para o display do item
      $ci['geratec_valor_unit_desembutido'] = $valor_display;
    }
  }
}, 20);

/* === 3) Adicionar a TARIFA como Fee — 1 linha por assento =================== */
add_action('woocommerce_cart_calculate_fees', function($cart){
  if (is_admin() && !defined('DOING_AJAX')) return;
  if (empty($cart)) return;

  static $executed = false; if ($executed) return; $executed = true;

  foreach ($cart->get_cart() as $key => $ci) {
    $product_id = isset($ci['product_id']) ? (int)$ci['product_id'] : 0;
    $qty        = max(1, (int)($ci['quantity'] ?? 1));
    $tarifa     = geratec_get_tarifa_transporte($product_id, $ci);

    if ($tarifa > 0 && $qty > 0) {
      $product = !empty($ci['data']) && is_a($ci['data'], 'WC_Product') ? $ci['data'] : null;
      $name    = $product ? $product->get_name() : ('#'.$product_id);

      for ($i=1; $i <= $qty; $i++) {
        $label = sprintf('Tarifa de Transporte — %s #%d', $name, $i);
        $cart->add_fee($label, $tarifa, (bool)GERATEC_TARIFA_TRIBUTAVEL);
      }
      // guardar para exibir no item
      $cart->cart_contents[$key]['geratec_tarifa_unit'] = $tarifa;
    }
  }
}, 30);

/* === 4) Exibir no item (carrinho/checkout): valor + tarifa = total ========= */
add_filter('woocommerce_get_item_data', function($item_data, $cart_item){
  if (empty($cart_item['data'])) return $item_data;

  $product     = $cart_item['data'];
  $qty         = max(1, (int)($cart_item['quantity'] ?? 1));

  // se desembutimos, use o valor desembutido; senão, pegue o preço exibido atual
  $valor_unit_display = isset($cart_item['geratec_valor_unit_desembutido'])
    ? (float)$cart_item['geratec_valor_unit_desembutido']
    : (float) wc_get_price_to_display($product);

  $tarifa_unit = isset($cart_item['geratec_tarifa_unit'])
    ? (float)$cart_item['geratec_tarifa_unit']
    : geratec_get_tarifa_transporte($cart_item['product_id'], $cart_item);

  $total_unit  = $valor_unit_display + $tarifa_unit;

  $display = sprintf(
    'valor  ( %1$s x %2$d ) = %3$s<br>tarifa ( %4$s x %2$d ) = %5$s<br><strong>total&nbsp;&nbsp;%6$s</strong>',
    wc_price($valor_unit_display), $qty, wc_price($valor_unit_display * $qty),
    wc_price($tarifa_unit),        wc_price($tarifa_unit * $qty),
    wc_price($total_unit * $qty)
  );

  $item_data[] = array(
    'key'     => 'Preço',
    'value'   => wp_kses_post($display),
    'display' => $display,
  );
  return $item_data;
}, 25, 2);

/* === 5) Gravar no pedido (admin/e-mail/obrigado) ============================ */
add_action('woocommerce_checkout_create_order_line_item', function($item, $cart_item_key, $values){
  $qty   = max(1, (int)($values['quantity'] ?? 1));

  $valor_unit_display = isset($values['geratec_valor_unit_desembutido'])
    ? (float)$values['geratec_valor_unit_desembutido']
    : (float) wc_get_price_to_display($values['data']);

  $tarifa_unit = isset($values['geratec_tarifa_unit'])
    ? (float)$values['geratec_tarifa_unit']
    : geratec_get_tarifa_transporte($values['product_id'], $values);

  $total_unit = $valor_unit_display + $tarifa_unit;

  $texto = sprintf(
    "valor ( %s x %d ) = %s | tarifa ( %s x %d ) = %s | total %s",
    wc_price($valor_unit_display), $qty, wc_price($valor_unit_display * $qty),
    wc_price($tarifa_unit),        $qty, wc_price($tarifa_unit * $qty),
    wc_price($total_unit * $qty)
  );
  $item->add_meta_data('Preço', $texto, true);
}, 10, 3);

 








/////////////////////////checkout 









 /**
 * === UPSERT de CLIENTES ao enviar o cadastro de encomenda ===
 * Aciona junto com action=cadastrar_encomenda e cria/atualiza
 * post_type=clientes para Remetente e Destinatário.
 */

/** Normaliza nome para comparação case/acento-insensitive */
function ljf_norm_name($s){
    $s = trim((string) $s);
    if ($s === '') return '';
    if (function_exists('transliterator_transliterate')) {
        $s = transliterator_transliterate('NFD; [:Nonspacing Mark:] Remove; NFC', $s);
    } else {
        $s = @iconv('UTF-8', 'ASCII//TRANSLIT//IGNORE', $s);
    }
    return strtolower(preg_replace('/\s+/', ' ', $s));
}

/** Busca cliente por TÍTULO (exato, ignorando caixa/acento) */
function ljf_find_client_by_title_ci($nome){
    if (!$nome) return 0;

    // tentativa rápida
    $p = get_page_by_title($nome, OBJECT, 'clientes');
    if ($p && $p->ID) return (int) $p->ID;

    // varredura
    $q = new WP_Query([
        'post_type'      => 'clientes',
        'post_status'    => ['publish','draft','pending','private'],
        's'              => $nome,
        'posts_per_page' => -1,
        'no_found_rows'  => true,
        'fields'         => 'ids',
    ]);
    $needle = ljf_norm_name($nome);
    foreach (($q->posts ?? []) as $pid){
        if (ljf_norm_name(get_the_title($pid)) === $needle) {
            wp_reset_postdata();
            return (int) $pid;
        }
    }
    wp_reset_postdata();
    return 0;
}

/** Busca cliente por DOC/telefone também */
function ljf_find_client_by_meta($doc, $tel){
    $doc = preg_replace('/\D+/','',(string)$doc);
    $tel = preg_replace('/\D+/','',(string)$tel);

    if ($doc !== '') {
        $q1 = new WP_Query([
            'post_type'      => 'clientes',
            'post_status'    => ['publish','draft','pending','private'],
            'posts_per_page' => 1,
            'no_found_rows'  => true,
            'fields'         => 'ids',
            'meta_query'     => [
                'relation'=>'OR',
                [ 'key'=>'cpf_cnpj','value'=>$doc,'compare'=>'=' ],
                [ 'key'=>'doc','value'=>$doc,'compare'=>'=' ],
            ],
        ]);
        if (!empty($q1->posts)) return (int)$q1->posts[0];
    }

    if ($tel !== '') {
        $q2 = new WP_Query([
            'post_type'      => 'clientes',
            'post_status'    => ['publish','draft','pending','private'],
            'posts_per_page' => 1,
            'no_found_rows'  => true,
            'fields'         => 'ids',
            'meta_query'     => [
                [ 'key'=>'telefone','value'=>$tel,'compare'=>'=' ],
            ],
        ]);
        if (!empty($q2->posts)) return (int)$q2->posts[0];
    }

    return 0;
}

/** Cria ou atualiza cliente (CPT 'clientes') sempre sobrescrevendo telefone/doc/cpf_cnpj */
function ljf_upsert_cliente($nome, $telefone, $doc){
    $nome     = sanitize_text_field($nome);
    $telefone = sanitize_text_field($telefone);
    $doc      = sanitize_text_field($doc);

    if ($nome === '' && $telefone === '' && $doc === '') return 0;

    // busca por meta (doc/tel) antes do título
    $pid = ljf_find_client_by_meta($doc, $telefone);
    if (!$pid && $nome !== '') {
        $pid = ljf_find_client_by_title_ci($nome);
    }

    // cria se não encontrou
    if (!$pid) {
        if ($nome === '') {
            $nome = $doc !== '' ? "Cliente {$doc}" : ($telefone !== '' ? "Cliente {$telefone}" : "Cliente sem nome");
        }
        $pid = wp_insert_post([
            'post_type'   => 'clientes',
            'post_status' => 'publish',
            'post_title'  => $nome,
        ], true);
        if (is_wp_error($pid)) return 0;
    }

    // atualiza nome se mudou
    if ($nome !== '' && ljf_norm_name(get_the_title($pid)) !== ljf_norm_name($nome)) {
        wp_update_post([ 'ID'=>$pid, 'post_title'=>$nome ]);
    }

    // grava metas
    update_post_meta($pid, 'telefone',  $telefone !== '' ? $telefone : '0');
    update_post_meta($pid, 'doc',       $doc !== '' ? $doc : '0');
    update_post_meta($pid, 'cpf_cnpj',  $doc !== '' ? $doc : '0');

   // Pods (opcional e silencioso)
if (function_exists('pods')) {
    try {
        $pod = pods('clientes', $pid);

        // só salva se o objeto Pods realmente existir
        if ($pod && !is_wp_error($pod)) {
            $pod->save('telefone',  $telefone);
            $pod->save('doc',       $doc);
            $pod->save('cpf_cnpj',  $doc);
        }
        // se não encontrar, simplesmente não faz nada (sem mensagem)
    } catch (Exception $e) {
        // registra no log, mas nunca mostra na tela
        error_log("Pods erro em clientes#{$pid}: " . $e->getMessage());
    }
}

return (int) $pid;

}

/**
 * Listener que roda ao enviar o form de encomenda.
 */
function ljf_upsert_clientes_on_encomenda_submit(){
    if (!isset($_POST['action']) || $_POST['action'] !== 'cadastrar_encomenda') return;
    if (!isset($_POST['freteq_cad_nonce']) || !wp_verify_nonce($_POST['freteq_cad_nonce'], 'freteq_cad')) return;

    // Remetente
    $nome_rem = $_POST['nome_remetente']      ?? '';
    $tel_rem  = $_POST['contato_remetente']   ?? '';
    $doc_rem  = $_POST['cpf_remetente']       ?? '';
    ljf_upsert_cliente(wp_unslash($nome_rem), wp_unslash($tel_rem), wp_unslash($doc_rem));

    // Destinatário
    $nome_des = $_POST['nome_destinatario']   ?? '';
    $tel_des  = $_POST['contato_destinatario']?? '';
    $doc_des  = $_POST['cpf_destinatario']    ?? '';
    ljf_upsert_cliente(wp_unslash($nome_des), wp_unslash($tel_des), wp_unslash($doc_des));
}
add_action('admin_post_cadastrar_encomenda',        'ljf_upsert_clientes_on_encomenda_submit', 1);
add_action('admin_post_nopriv_cadastrar_encomenda', 'ljf_upsert_clientes_on_encomenda_submit', 1);

 




// AJAX: criar produto manual no CPT `cad_frete_produto`
add_action('wp_ajax_adicionar_produto_manual', 'brq_ajax_adicionar_produto_manual');
add_action('wp_ajax_nopriv_adicionar_produto_manual', 'brq_ajax_adicionar_produto_manual');

function brq_ajax_adicionar_produto_manual() {
  // (Opcional) valida nonce se você quiser — ative tb no JS
  // if ( ! isset($_POST['nonce']) || ! wp_verify_nonce($_POST['nonce'], 'brq_add_prod_nonce') ) {
  //   wp_send_json_error(['message' => 'Falha de segurança (nonce).']);
  // }

  $nome  = isset($_POST['nome'])  ? sanitize_text_field($_POST['nome'])  : '';
  $valor = isset($_POST['valor']) ? floatval($_POST['valor']) : 0;

  if ($nome === '' || $valor <= 0) {
    wp_send_json_error(['message' => 'Nome e valor são obrigatórios.']);
  }

  // Garante que o CPT exista (ele deve ser registrado por você em outro lugar)
  if ( ! post_type_exists('produto_encomenda') ) {
    wp_send_json_error(['message' => 'Tipo de post "cad_frete_produto" não encontrado.']);
  }

  // Evitar duplicidade por título (opcional): se já existir, reaproveita
  $existente = get_page_by_title($nome, OBJECT, 'cad_frete_produto');
  if ($existente && ! is_wp_error($existente)) {
    $post_id = (int) $existente->ID;
    update_post_meta($post_id, 'valor', $valor);
    wp_send_json_success(['id' => $post_id, 'nome' => $nome, 'valor' => $valor]);
  }

  // Cria o produto
  $post_id = wp_insert_post([
    'post_title'  => $nome, 
    'post_type'   => 'produto_encomenda',
    'post_status' => 'publish',
  ], true);

  if (is_wp_error($post_id) || ! $post_id) {
    wp_send_json_error(['message' => 'Erro ao criar o produto.']);
  }

  update_post_meta($post_id, 'valor', $valor);

  wp_send_json_success([
    'id'    => (int)$post_id,
    'nome'  => $nome,
    'valor' => (float)$valor,
  ]);
}





/**
 * Remove todas as notificações do painel do WordPress
 */
add_action('admin_head', function () {
    // Remove avisos de plugins e temas
    remove_all_actions('admin_notices');
    remove_all_actions('all_admin_notices');
    remove_all_actions('network_admin_notices');
    remove_all_actions('user_admin_notices');

    // Remove aviso de atualização do WordPress/core
    remove_action('admin_notices', 'update_nag', 3);

    // Remove também banners de update de plugins/temas
    add_filter('pre_site_transient_update_core', '__return_null');
    add_filter('pre_site_transient_update_plugins', '__return_null');
    add_filter('pre_site_transient_update_themes', '__return_null');
});

/**
 * Opcional: Esconde via CSS qualquer .notice que escapar
 */
add_action('admin_head', function () {
    echo '<style>.notice, .update-nag, .updated, .error, .is-dismissible { display:none !important; }</style>';
});











 //////////// WOO ESCONDER
 



 
 
// ===== GERATEC (ÚNICO): Tarifa do Gratuito + Desconto sobre o TOTAL (sem duplicar) =====
if (!defined('ABSPATH')) { exit; }

/* Utils */
if (!function_exists('geru_norm')) {
  function geru_norm($s){
    $s = trim((string)$s);
    if ($s === '') return '';
    if (function_exists('transliterator_transliterate')) {
      $s = transliterator_transliterate('NFD; [:Nonspacing Mark:] Remove; NFC', $s);
    } elseif (function_exists('iconv')) {
      $s = @iconv('UTF-8','ASCII//TRANSLIT//IGNORE',$s);
    }
    return strtolower($s);
  }
}
if (!function_exists('geru_to_float')) {
  function geru_to_float($v){
    if (is_numeric($v)) return (float)$v;
    $v = (string)$v;
    $v = preg_replace('/[^\d,.\-]/','',$v);
    $v = preg_replace('/\.(?=\d{3}(?:\D|$))/','',$v); // milhar .
    $v = str_replace(',', '.', $v);                   // vírgula -> ponto
    return (float)$v;
  }
}

/* Detectores */
if (!function_exists('geru_is_free')) {
  function geru_is_free($ci){
    foreach (['tipo_assento','seat_label','category','categoria','label','tipo'] as $k){
      if (!empty($ci[$k]) && strpos(geru_norm($ci[$k]), 'grat') !== false) return true;
    }
    if (!empty($ci['wbtm_seats']) && is_array($ci['wbtm_seats'])) {
      $r = is_array(reset($ci['wbtm_seats'])) ? reset($ci['wbtm_seats']) : null;
      if (!empty($r['ticket_name']) && strpos(geru_norm($r['ticket_name']), 'grat') !== false) return true;
    }
    return false;
  }
}
if (!function_exists('geru_is_child_50')) {
  function geru_is_child_50($ci){
    if (isset($ci['ticket_type']) && (string)$ci['ticket_type'] === '1') return true;
    $cands = [];
    foreach (['tipo_assento','seat_label','category','categoria','label','tipo'] as $k){ if (!empty($ci[$k])) $cands[] = $ci[$k]; }
    if (!empty($ci['wbtm_seats']) && is_array($ci['wbtm_seats'])) {
      $r = is_array(reset($ci['wbtm_seats'])) ? reset($ci['wbtm_seats']) : null;
      if ($r){
        foreach (['ticket_name','label','fare_name','category','categoria'] as $rk){ if (!empty($r[$rk])) $cands[] = $r[$rk]; }
        if (isset($r['ticket_type']) && (string)$r['ticket_type'] === '1') return true;
      }
    }
    foreach ($cands as $txt){
      $n = geru_norm($txt);
      $kid  = preg_match('/crian|crianca|criança|child|kids|infantil|menor/', $n);
      $half = preg_match('/50\s*%|\b50\b|meia|1\/2|metade|half/', $n);
      if ($kid && $half) return true;
    }
    return false;
  }
}

/* Lê tarifa-base (ex.: 55) do produto/rota/item */
if (!function_exists('geru_tarifa_base')) {
  function geru_tarifa_base($product_id, $ci = null){
    $keys = ['geratec_tarifa_unit','tarifa_transporte','_tarifa_transporte','_taxa_transporte','_ger_tarifa','_tarifa','tarifa'];
    foreach ($keys as $k){ if (is_array($ci) && isset($ci[$k]) && $ci[$k] !== '') return max(0.0, geru_to_float($ci[$k])); }
    foreach ($keys as $mk){ $v = get_post_meta((int)$product_id, $mk, true); if ($v !== '' && $v !== null) return max(0.0, geru_to_float($v)); }
    if (is_array($ci)){
      foreach (['wbtm_bus_id','bus_id','route_id'] as $idk){
        $rid = (int)($ci[$idk] ?? 0);
        if ($rid) {
          foreach ($keys as $mk){ $v = get_post_meta($rid, $mk, true); if ($v !== '' && $v !== null) return max(0.0, geru_to_float($v)); }
        }
      }
    }
    return 0.0;
  }
}

/* Preço do assento */
if (!function_exists('geru_ticket_assento')) {
  function geru_ticket_assento($ci){
    if (isset($ci['wbtm_ticket_price'])) return max(0.0, geru_to_float($ci['wbtm_ticket_price']));
    if (!empty($ci['wbtm_seats']) && is_array($ci['wbtm_seats'])) {
      $r = is_array(reset($ci['wbtm_seats'])) ? reset($ci['wbtm_seats']) : null;
      if (!empty($r['ticket_price'])) return max(0.0, geru_to_float($r['ticket_price']));
    }
    $p = (!empty($ci['data']) && is_a($ci['data'],'WC_Product')) ? $ci['data'] : null;
    return $p ? (float) wc_get_price_to_display($p) : 0.0;
  }
}

/* “Virtual rows” (1 por assento/qty) */
if (!function_exists('geru_virtual_rows')) {
  function geru_virtual_rows($ci){
    $rows = [];
    $qty    = max(1, (int)($ci['quantity'] ?? 1));
    $nSeats = (!empty($ci['wbtm_seats']) && is_array($ci['wbtm_seats'])) ? count($ci['wbtm_seats']) : 0;
    $nPass  = (!empty($ci['wbtm_passenger_info']) && is_array($ci['wbtm_passenger_info'])) ? count($ci['wbtm_passenger_info']) : 0;
    $units  = max($qty, $nSeats, $nPass, 1);

    if ($nSeats) {
      $seats = array_values($ci['wbtm_seats']);
      foreach ($seats as $r){
        $row = $ci;
        if ($r){
          if (!empty($r['ticket_name']))   $row['tipo_assento']      = $r['ticket_name'];
          if (!empty($r['seat_name']))     $row['seat_label']        = $r['seat_name'];
          if (isset($r['ticket_type']))    $row['ticket_type']       = $r['ticket_type'];
          if (!empty($r['date']))          $row['wbtm_date']         = $r['date'];
          if (!empty($r['ticket_price']))  $row['wbtm_ticket_price'] = geru_to_float($r['ticket_price']);
          $row['wbtm_seats'] = [$r];
        }
        $rows[] = $row;
      }
    } else {
      for ($i=0; $i<$units; $i++){ $rows[] = $ci; }
    }
    return $rows;
  }
}

/* Somas com a regra: Adulto = (ticket-base)+base; Criança50 = ticket; Gratuito = base */
if (!function_exists('geru_sum_pass_tax_e_taxa_gratuito')) {
  function geru_sum_pass_tax_e_taxa_gratuito($cart){
    $sum_pass = 0.0; $sum_taxas = 0.0; $taxa_gratuito = 0.0;
    foreach ($cart->get_cart() as $ci) {
      foreach (geru_virtual_rows($ci) as $row) {
        $ticket = geru_ticket_assento($row);
        $base   = geru_tarifa_base($row['product_id'] ?? 0, $row);
        if (geru_is_child_50($row)) {
          $sum_pass  += $ticket;       // criança 50% sem taxa
          $sum_taxas += 0.0;
        } elseif (geru_is_free($row)) {
          $sum_pass  += 0.0;           // gratuito paga só taxa
          $sum_taxas += $base;
          $taxa_gratuito += $base;     // essa vira fee positiva
        } else {
          $sum_pass  += max(0.0, $ticket - $base); // adulto: passagem
          $sum_taxas += $base;                      // e taxa-base
        }
      }
    }
    return [$sum_pass, $sum_taxas, $taxa_gratuito];
  }
}

/* Lê desconto do request atual (update_checkout) ou sessão */
if (!function_exists('geru_get_discount_request')) {
  function geru_get_discount_request(){
    $data = [];
    if (isset($_POST['post_data'])) {
      parse_str(wp_unslash($_POST['post_data']), $data); // padrão Woo
    } elseif (!empty($_POST)) {
      $data = wp_unslash($_POST);
    }
    $val  = array_key_exists('wa_discount', $data)      ? geru_to_float($data['wa_discount']) : null; // null = não veio no POST
    $type = isset($data['wa_discount_type']) ? (string)$data['wa_discount_type'] : 'fixed';
    return [$val, $type];
  }
}

/* Persiste em sessão quando atualizar o checkout */
add_action('woocommerce_checkout_update_order_review', function($posted_data){
  if (!WC()->session) return;
  $data = [];
  if (is_string($posted_data)) { parse_str($posted_data, $data); }
  elseif (is_array($posted_data)) { $data = $posted_data; }
  else { $data = $_POST ?? []; }

  $val  = isset($data['wa_discount']) ? geru_to_float($data['wa_discount']) : 0.0;
  $type = isset($data['wa_discount_type']) ? (string)$data['wa_discount_type'] : 'fixed';

  if ($val > 0){
    WC()->session->set('ger_target_discount', ['set'=>true, 'val'=>$val, 'type'=>$type]);
  } else {
    WC()->session->set('ger_target_discount', ['set'=>false, 'val'=>0, 'type'=>'fixed']);
  }
}, 10, 1);

/* ÚNICO hook que aplica: fee positiva do gratuito + desconto líquido (sem duplicar) */
add_action('woocommerce_cart_calculate_fees', function($cart){
  if (is_admin() && !defined('DOING_AJAX')) return;
  if (!$cart) return;

  // 1) Totais pela regra
  list($sum_pass, $sum_taxas, $taxa_gratuito) = geru_sum_pass_tax_e_taxa_gratuito($cart);
  $baseTotal = max(0.0, $sum_pass + $sum_taxas);

  // Fee POSITIVA: tarifa de itens "Gratuito"
  if ($taxa_gratuito > 0) {
    $cart->add_fee(__('Tarifa (gratuito)', 'geratec'), $taxa_gratuito, false);
  }

  // 2) Desconto desejado (sobre o TOTAL = passagens + taxas)
  list($val_now, $type_now) = geru_get_discount_request();
  $raw  = 0.0; $type = 'fixed';

  if ($val_now !== null) {
    $raw  = max(0.0, (float)$val_now);
    $type = $type_now ?: 'fixed';
    if (WC()->session) WC()->session->set('ger_target_discount', ['set'=>($raw>0), 'val'=>$raw, 'type'=>$type]);
  } else {
    $pv = WC()->session ? WC()->session->get('ger_target_discount') : null;
    if (!empty($pv['set']) && (float)$pv['val'] > 0) {
      $raw  = (float)$pv['val'];
      $type = (string)($pv['type'] ?? 'fixed');
    }
  }

  if ($raw > 0 && $baseTotal > 0) {
    $desired = preg_match('/%|percent/i', $type) ? ($baseTotal * ($raw/100.0)) : $raw;
    $desired = max(0.0, min($desired, $baseTotal));

    // 3) EVITAR DUPLICIDADE: mede o que já foi aplicado (cupons + fees negativas de outros plugins)
    $already = 0.0;
    foreach ((array)$cart->fees_api()->get_fees() as $fee) {
      $amount = isset($fee->amount) ? (float)$fee->amount : 0.0;
      if ($amount < 0) $already += abs($amount);
    }
    $already += (float)$cart->get_discount_total(); // cupons

    // 4) Aplica só a diferença, para o total descontado bater no valor desejado
    $effective = max(0.0, $desired - $already);
    if ($effective > 0.0) {
      $cart->add_fee(__('Desconto (operador)', 'geratec'), -$effective, false);
    }
  }
}, 999);





 